﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using RevisionAnalyser.Global;

namespace RevisionAnalyser
{
    public partial class OptionsForm : Form
    {
        public OptionsForm()
        {
            InitializeComponent();
        }

        private void LoadGlobalVariables()
        {
            uxGlobalsView.Items.Clear();
            Dictionary<string, string> variables = GlobalVariables.Instance.GetVariables();
            foreach (KeyValuePair<string, string> variable in variables)
            {
                uxGlobalsView.Items.Add(new ListViewItem(new string[] { variable.Key, variable.Value }));
            }
        }

        private void SaveGlobalVariables()
        {
            GlobalVariables.Instance.DeleteVariables();
            foreach (ListViewItem item in uxGlobalsView.Items)
            {
                GlobalVariables.Instance.SetVariable(item.Text, item.SubItems[1].Text);
            }
        }

        private bool DoesGlobalExist(string name)
        {
            name = name.ToUpper();
            foreach (ListViewItem item in uxGlobalsView.Items)
            {
                if (item.Text.Equals(name))
                {
                    return true;
                }
            }
            return false;
        }

        private void AddGlobalVariable()
        {
            GlobalVariableForm frmGlobalVariable = new GlobalVariableForm("Please enter the name and value for the global variable you would like to add.", string.Empty, string.Empty, false, true);
            if (frmGlobalVariable.ShowDialog() == DialogResult.OK)
            {
                if (!DoesGlobalExist(frmGlobalVariable.GetName()))
                {
                    uxGlobalsView.Items.Add(new ListViewItem(new string[] { frmGlobalVariable.GetName(), frmGlobalVariable.GetValue() }));
                }
                else
                {
                    MessageBox.Show(String.Format("The global variable '{0}' already exists!", frmGlobalVariable.GetName()), "Duplicate variable", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }
            }
        }

        private void EditGlobalVariable(ListViewItem item)
        {
            GlobalVariableForm frmGlobalVariable = new GlobalVariableForm(String.Format("Please enter a new value for the global variable '{0}'.", item.Text), item.Text, item.SubItems[1].Text, true, true);
            if (frmGlobalVariable.ShowDialog() == DialogResult.OK)
            {
                item.SubItems[1].Text = frmGlobalVariable.GetValue();
            }
        }

        private void DeleteGlobalVariable(ListViewItem item)
        {
            if (MessageBox.Show(String.Format("Do you want to remove the global variable '{0}'?", item.Text), "Remove variable", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
            {
                uxGlobalsView.Items.Remove(item);
                uxGlobalsView_SelectedIndexChanged(null, null);
            }
        }

        private void OptionsForm_Load(object sender, EventArgs e)
        {
            LoadGlobalVariables();
        }

        private void uxAddGlobalButton_Click(object sender, EventArgs e)
        {
            AddGlobalVariable();
        }

        private void uxEditGlobalButton_Click(object sender, EventArgs e)
        {
            EditGlobalVariable(uxGlobalsView.SelectedItems[0]);
        }

        private void uxGlobalsView_SelectedIndexChanged(object sender, EventArgs e)
        {
            uxEditGlobalButton.Enabled = uxGlobalsView.SelectedItems.Count > 0;
            uxDeleteGlobalButton.Enabled = uxEditGlobalButton.Enabled;
        }

        private void uxDeleteGlobalButton_Click(object sender, EventArgs e)
        {
            DeleteGlobalVariable(uxGlobalsView.SelectedItems[0]);
        }

        private void uxCancelButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void uxOKButton_Click(object sender, EventArgs e)
        {
            SaveGlobalVariables();
            DialogResult = DialogResult.OK;
            Close();
        }
    }
}
